/*
 * Copyright (c) 2018,2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java

class ClassCm extends ClassCd {
    String modifiers = JavaDefs.MODIFIER_PUBLIC

    String description

    Collection<String> imports = new LinkedHashSet<>()
    List<AnnotationCm> annotations = []
    List<FieldCm> fields = []
    List<MethodCm> methods = []
    List<ClassCd> interfaces = []
    List<EnumItemCm> enumItems = []

    void addField(FieldCm fieldCm) {
        assert fields.find {
            it.name == fieldCm.name || (it.model != null && it.model == fieldCm.model)
        } == null, "field $fieldCm.name already exists"
        fields.add(fieldCm)
    }

    FieldCm getField(def schema) {
        def result = fields.find { it.model == schema }
        if (result == null) {
            throw new IllegalStateException("No field found for: $schema, in class: $this")
        }
        result
    }

    void addMethod(MethodCm methodCm) {
        methods.each {
            if (methodCm.matchNameAndParams(it)) {
                throw new IllegalStateException("Can't add method: $methodCm; is in conflict with $it")
            }
        }
        methods.add(methodCm)
    }

    List<MethodCm> getMethods() {
        methods.asUnmodifiable()
    }

    void addEnumItem(EnumItemCm itemCm) {
        if (!isEnum) {
            throw new IllegalStateException("Class $className is not an enum")
        }
        enumItems.each {
            if (it.name == itemCm.name) {
                throw new IllegalStateException("Can't add enum item: $itemCm.name; item already exists.")
            }
        }
        enumItems.add(itemCm)
    }

}
