/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java

import pl.metaprogramming.codemodel.builder.CodeGenerationTask
import pl.metaprogramming.codemodel.builder.java.ClassBuilderConfigurator
import pl.metaprogramming.codemodel.builder.java.config.CodegenParams
import pl.metaprogramming.codemodel.model.java.index.ClassIndex

abstract class ClassBuilder<T> {
    T model
    CodegenParams params
    ClassBuilderConfigurator config
    ClassIndex classIndex

    Object getClassType() {
        config.classType
    }

    abstract ClassCd getClassCd()

    abstract void makeDeclaration()

    abstract void makeDecoration()

    abstract void makeImplementation()

    abstract CodeGenerationTask makeGenerationTask(String filePath)
}