/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.xml

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.AnnotationCm
import pl.metaprogramming.codemodel.model.java.MethodCm
import pl.metaprogramming.metamodel.data.DataSchema

import static pl.metaprogramming.codemodel.builder.java.ClassType.XML_DTO

class XmlObjectFactoryBuildStrategy extends ClassCmBuildStrategy<List<DataSchema>> {

    static AnnotationCm XML_REGISTRY = new AnnotationCm('javax.xml.bind.annotation.XmlRegistry')

    @Override
    void makeImplementation() {
        addAnnotation(XML_REGISTRY)
        addMethods(model.collect { schema ->
            def schemaClass = getClass(XML_DTO, schema.dataType)
            new MethodCm(
                    resultType: schemaClass,
                    name: "create$schemaClass.className",
                    implBody: "return new $schemaClass.className();"
            )
        } as MethodCm[])
    }

}
