/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring.mapper

import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm

import static pl.metaprogramming.codemodel.builder.java.ClassType.DTO
import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_DTO
import static pl.metaprogramming.codemodel.model.java.JavaDefs.ANNOT_NON_NULL
import static pl.metaprogramming.codemodel.model.java.JavaDefs.OBJECTS

class RestOutResponseSuccessMapperBuilder extends RestOutResponseMapperBuilder {

    @Override
    MethodCm makeDeclaration() {
        new MethodCm(
                name: 'map',
                resultType: responseClass,
                params: [new FieldCm(name: RESPONSE_PARAM, type: helper.responseEntity, annotations: [ANNOT_NON_NULL])],
        )
    }

    @Override
    String makeImplBody() {
        codeBuf
                .addLines(helper.successResponse.isDefault()
                        ? "return ${responseObjectCreatePrefix}.setOther(responseEntity.getStatusCodeValue(), $successDataResolver);"
                        : "return ${responseObjectCreatePrefix}.set${helper.successResponse.status}($successDataResolver);")
                .take()
    }

    private String getSuccessDataResolver() {
        if (helper.hasResponseBody()) {
            String restDtoExp = "${RESPONSE_PARAM}.getBody()"
            def result = strategy.transform(REST_DTO, DTO, helper.responseObject, restDtoExp).value
            if (result.toString() == restDtoExp) {
                strategy.addImports(OBJECTS)
                "Objects.requireNonNull($restDtoExp)"
            } else {
                result
            }
        } else {
            ''
        }
    }
}
