/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring.mapper

import groovy.transform.TypeChecked
import groovy.transform.TypeCheckingMode
import pl.metaprogramming.codemodel.builder.java.config.SpringRestParams
import pl.metaprogramming.codemodel.builder.java.mapper.BaseMethodCmBuilder
import pl.metaprogramming.codemodel.builder.java.spring.RestClientBuildHelper
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.metamodel.oas.Operation

import static pl.metaprogramming.codemodel.builder.java.ClassType.RESPONSE_DTO

abstract class RestOutResponseMapperBuilder extends BaseMethodCmBuilder<Operation> {

    protected static final String RESPONSE_PARAM = 'responseEntity'

    @Lazy
    protected RestClientBuildHelper helper = new RestClientBuildHelper(strategy, model)

    @Lazy
    protected ClassCd responseClass = strategy.getClass(RESPONSE_DTO)

    protected String getResponseObjectCreatePrefix() {
        isStaticFactoryMethod()
                ? responseClass.className
                : "new ${responseClass.className}()"
    }

    @TypeChecked(TypeCheckingMode.SKIP)
    private boolean isStaticFactoryMethod() {
        strategy.getParams(SpringRestParams).staticFactoryMethodForRestResponse
    }

}
