/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring.mapper

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.spring.RestParamsBuilder
import pl.metaprogramming.metamodel.oas.Operation

import static pl.metaprogramming.codemodel.builder.java.ClassType.REQUEST_DTO
import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_DTO
import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_REQUEST_DTO

class RestInRequestMapperBuildStrategy extends ClassCmBuildStrategy<Operation> {

    @Override
    void makeDeclaration() {
        addMapper new DtoMapperBuilder()
                .setObjectType(model.requestSchema)
                .setFromFields(new RestParamsBuilder(this, REST_DTO).make(model))
                .setTo(getClassCm(REST_REQUEST_DTO))

        addMapper new DtoMapperBuilder()
                .setObjectType(model.requestSchema)
                .setHandleNullParam(true)
                .setFrom(getClassCm(REST_REQUEST_DTO))
                .setTo(getClassCm(REQUEST_DTO))
    }
}
