/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring


import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm
import pl.metaprogramming.metamodel.wsdl.WsdlApi

import static pl.metaprogramming.codemodel.builder.java.ClassType.XML_DTO

class WsClientBuildStrategy extends ClassCmBuildStrategy<WsdlApi> {
    static final ClassCd SUPERCLASS = new ClassCd('org.springframework.ws.client.core.support.WebServiceGatewaySupport')

    @Override
    void makeImplementation() {
        setSuperClass(SUPERCLASS)
        addMethods(model.operations.collect {
            def resultType = getClass(XML_DTO, it.output.dataType)
            new MethodCm(
                    name: it.name,
                    resultType: resultType,
                    params: [new FieldCm(name: 'request', type: getClass(XML_DTO, it.input.dataType))],
                    implBody: "return ($resultType.className) getWebServiceTemplate().marshalSendAndReceive(request);"
            )
        } as MethodCm[])
    }
}
