/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.metamodel.data.DataType
import pl.metaprogramming.metamodel.oas.HttpResponse
import pl.metaprogramming.metamodel.oas.Operation

import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_DTO
import static pl.metaprogramming.codemodel.builder.java.spring.SpringDefs.*
import static pl.metaprogramming.codemodel.model.java.JavaDefs.*

class RestClientBuildHelper {
    ClassCmBuildStrategy<?> builder
    Operation operation

    RestClientBuildHelper(ClassCmBuildStrategy<?> builder, Operation operation) {
        this.builder = builder
        this.operation = operation
    }

    ClassCd getRequestEntity() {
        new ClassCd(REQUEST_ENTITY, [getHttpEntityBodyClass()])
    }

    ClassCd getHttpEntityBodyClass() {
        if (operation.multipart) {
            MULTI_VALUE_MAP
        } else if (operation.requestBodySchema) {
            builder.getClass(REST_DTO, operation.requestBodySchema.dataType)
        } else {
            ClassCd.VOID
        }
    }

    HttpResponse getSuccessResponse() {
        if (operation.responses.size() == 1 && operation.responses.first().isDefault()) {
            operation.responses.first()
        } else {
            operation.successResponse
        }
    }

    boolean hasResponseBody() {
        successResponse?.schema?.dataType != null
    }

    DataType getResponseObject() {
        successResponse?.schema?.dataType
    }

    ClassCd getResponseClass() {
        hasResponseBody() ? builder.getClass(REST_DTO, responseObject) : T_STRING
    }

    ClassCd getResponseEntity() {
        new ClassCd(RESPONSE_ENTITY, [hasResponseBody() ? responseClass : GENERIC_ANY])
    }
}
