/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.formatter.CodeBuffer
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.metamodel.oas.Operation

class ReactiveWrapperBuildStrategy extends ClassCmBuildStrategy<Operation> {

    static final ClassCd MONO_CLASS = new ClassCd('reactor.core.publisher.Mono')
    static final ClassCd SCHEDULER_CLASS = new ClassCd('reactor.core.scheduler.Scheduler')

    @Override
    void makeImplementation() {
        def schedulerField = createSchedulerField()
        addImports('reactor.core.scheduler.Schedulers')
        methods.each {
            it.resultType = new ClassCd(MONO_CLASS, [it.resultType])
            it.implBody = new CodeBuffer()
                    .newLine('return Mono.fromSupplier(() -> {')
                    .indent(1)
                    .addLines(it.implBody)
                    .newLine("}).subscribeOn(${schedulerField.name});")
                    .take()
        }
    }

    FieldCm createSchedulerField() {
        def field = new FieldCm(SCHEDULER_CLASS, 'scheduler')
                .assign("Schedulers.newElastic(\"$modelName\")")
                .setFinal()
        addFields(field)
        field
    }
}
