package pl.metaprogramming.codemodel.builder.java.spring

import groovy.transform.TypeChecked
import groovy.transform.TypeCheckingMode
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.config.SpringRestParams
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.JavaDefs
import pl.metaprogramming.metamodel.oas.Operation

class PayloadFieldAppenderBuildStrategy extends ClassCmBuildStrategy<Operation> {

    @Override
    @TypeChecked(TypeCheckingMode.SKIP)
    void makeImplementation() {
        if (getParams(SpringRestParams).payloadField && model.requestBodySchema) {
            addFields(new FieldCm(JavaDefs.T_STRING, getParams(SpringRestParams).payloadField))
        }
    }

}
