/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring


import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.JavaDefs

class DiConstructorBuildStrategy extends ClassCmBuildStrategy {

    @Override
    void makeDecoration() {
        def fields = findFields { isFieldForDi(it) }
        if (fields) {
            addAnnotation(JavaDefs.ANNOT_LB_REQUIRED_ARGS_CONTR)
            fields.each { it.setFinal() }
        }
    }

    boolean isFieldForDi(FieldCm fieldCm) {
        !fieldCm.isStatic() &&
                fieldCm.value == null &&
                null == fieldCm.annotations.find { it.canonicalName == SpringDefs.ANNOT_VALUE }
    }
}
