/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.ClassType
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm

import static pl.metaprogramming.codemodel.model.java.JavaDefs.*

class ValidationExceptionBuildStrategy extends ClassCmBuildStrategy<Object> {

    @Override
    void makeImplementation() {
        setSuperClass('java.lang.RuntimeException')
        addImport(T_STREAM_COLLECTORS)
        addAnnotations([ANNOT_LB_ALL_ARGS_CONTR, ANNOT_LB_GETTER])
        addFields(new FieldCm(getClass(ClassType.VALIDATION_RESULT), 'result').setModifiers(MODIFIER_PRIVATE_FINAL))
        addMethods new MethodCm(
                name: 'getMessage',
                annotations: [ANNOT_OVERRIDE],
                resultType: T_STRING,
                implBody: '''String errors = result.getErrors().stream()
        .map(err -> err.getField() == null ? err.getCode() : String.format("%s - %s", err.getField(), err.getCode()))
        .collect(Collectors.joining(", "));
return String.format("Failed validation (%d) with errors: %s", result.getStatus(), errors);'''
        )
    }
}
