/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy

import static pl.metaprogramming.codemodel.model.java.JavaDefs.*

class ValidationErrorBuildStrategy extends ClassCmBuildStrategy<Object> {

    @Override
    void makeImplementation() {
        addAnnotations([ANNOT_LB_BUILDER, ANNOT_LB_VALUE])
        addInterfaces I_SERIALIZABLE
        addField('field', T_STRING)
        addField('code', T_STRING)
        addField('message', T_STRING)
        addField('messageArgs', T_OBJECT.array())
        addField('stopValidation', T_BOOLEAN_PRIMITIVE)
        addField('status', T_INTEGER)
    }
}
