/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.config.SpringRestParams
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm

import static pl.metaprogramming.codemodel.model.java.JavaDefs.*

class RestResponseInterfaceBuildStrategy extends ClassCmBuildStrategy {

    @Override
    void makeImplementation() {
        setInterface()
        addGenericParams(GENERIC_R)
        addAnnotation(ANNOT_PARAMETERS_ARE_NONNULL_BY_DEFAULT)
        addImports(OBJECTS)
        addMethods(
                new MethodCm(name: 'getBody', resultType: T_OBJECT),
                new MethodCm(name: 'getStatus', resultType: T_INTEGER),
                new MethodCm(name: 'self', resultType: GENERIC_R),
                new MethodCm(name: 'getDeclaredStatuses', resultType: COLLECTION_OF_INT),
                new MethodCm(name: 'getHeaders', resultType: new ClassCd(T_MAP, [T_STRING, T_STRING])),
                new MethodCm(
                        name: 'setHeader',
                        modifiers: MODIFIER_DEFAULT,
                        resultType: GENERIC_R,
                        params: [new FieldCm(T_STRING, 'name'),
                                 new FieldCm(T_STRING, 'value')],
                        implBody: codeBuf.addLines('getHeaders().put(name, value);', 'return self();').take()),
                new MethodCm(
                        name: 'isStatus',
                        modifiers: MODIFIER_DEFAULT,
                        resultType: T_BOOLEAN_PRIMITIVE,
                        params: [new FieldCm(T_INTEGER, 'status')],
                        implBody: 'return Objects.equals(status, getStatus());'),
        )

        if (!getParams(SpringRestParams).staticFactoryMethodForRestResponse) {
            addMethods(new MethodCm(
                    name: 'set',
                    params: [new FieldCm(T_INTEGER, 'status'),
                            new FieldCm(T_OBJECT, 'body')],
                    resultType: GENERIC_R)
            )
        }
    }
}
