/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.builder.java.mapper.InheritFromTemplateMethodCmBuilder
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.metamodel.oas.Operation

import static pl.metaprogramming.codemodel.builder.java.ClassType.VALIDATION_RESULT
import static pl.metaprogramming.codemodel.builder.java.ClassType.VALIDATION_VALIDATOR

class RestRequestValidatorBuildStrategy extends ValidatorBuildStrategy {

    RestRequestValidatorBuildStrategy() {
        modelMapper = { Operation it -> it.requestSchema }
    }

    @Override
    void makeDeclaration() {
        addMapper new InheritFromTemplateMethodCmBuilder(
                'validate',
                getClass(VALIDATION_RESULT),
                [dtoClass] as List<ClassCd>)
    }

    @Override
    void makeImplementation() {
        setSuperClass(getGenericClass(VALIDATION_VALIDATOR, [dtoClass]))
        addCheckMethod()
    }
}
