/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.builder.java.StatefulClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.spring.mapper.DtoMapperBuilder
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.ClassCm
import pl.metaprogramming.metamodel.data.ObjectType

import static pl.metaprogramming.codemodel.builder.java.ClassType.DTO
import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_DTO

class RestDtoMapperBuildStrategy extends StatefulClassCmBuildStrategy<ObjectType> {

    @Override
    void makeDeclaration() {
        if (restDtoClass instanceof ClassCm) {
            addMappers(
                    new DtoMapperBuilder()
                            .setFrom(restDtoClass)
                            .setTo(dtoClass)
                            .setCallMapperWithResultParamAsImpl(true)
                            .setObjectType(model),
                    new DtoMapperBuilder()
                            .setFrom(dtoClass)
                            .setTo(restDtoClass)
                            .setCallMapperWithResultParamAsImpl(true)
                            .setObjectType(model),
                    new DtoMapperBuilder()
                            .setFrom(restDtoClass)
                            .setTo(dtoClass)
                            .setResultAsParam(true)
                            .setObjectType(model),
                    new DtoMapperBuilder()
                            .setFrom(dtoClass)
                            .setTo(restDtoClass)
                            .setResultAsParam(true)
                            .setObjectType(model)
            )
        } else {
            // TODO JWT support
            addMappers(
                    new DtoMapperBuilder()
                            .setFrom(restDtoClass)
                            .setTo(dtoClass)
                            .setThrowNotImplementedExceptionAsImpl(true)
                            .setObjectType(model),
                    new DtoMapperBuilder()
                            .setFrom(dtoClass)
                            .setTo(restDtoClass)
                            .setThrowNotImplementedExceptionAsImpl(true)
                            .setObjectType(model),
            )
        }
    }

    ClassCd getDtoClass() {
        findClass(DTO)
    }

    ClassCd getRestDtoClass() {
        findClass(REST_DTO)
    }
}
