/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

class FormatValidators {

    private final Map<String, ValidatorPointer> validators = [:]

    FormatValidators setIfNotPresent(String format, String validator) {
        if (!validators.containsKey(format)) {
            set(format, validator)
        }
        this
    }

    FormatValidators set(String format, String validator) {
        validators.put(format, ValidatorPointer.fromExpression(validator))
        this
    }

    ValidatorPointer getValidator(String format) {
        validators.get(format)
    }

    FormatValidators clone() {
        def result = new FormatValidators()
        validators.forEach(result.validators.&put)
        result
    }
}
