/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.mapper

import pl.metaprogramming.codemodel.builder.java.MethodCmBuilder
import pl.metaprogramming.codemodel.formatter.ClassNameFormatter
import pl.metaprogramming.codemodel.formatter.CodeBuffer
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm

import java.util.function.Function

abstract class BaseMethodCmBuilder<T> extends MethodCmBuilder {

    protected Function<?, T> modelMapper = { it as T } as Function<?, T>

    protected static ClassNameFormatter classNameFormatter = new ClassNameFormatter()

    abstract String makeImplBody()

    void makeImplementation() {
        strategy = strategy.getInstance(builder)
        methodCm.implBody = makeImplBody()
        builder.addMethod(methodCm)
    }

    protected T getModel() {
        modelMapper.apply(strategy.model)
    }

    protected CodeBuffer getCodeBuf() {
        strategy.codeBuf
    }

    protected ClassCd getClass(def classType) {
        strategy.getClass(classType, model)
    }

    protected String componentRef(def classType) {
        strategy.injectDependency(getClass(classType)).name
    }

    protected String getter(String...path) {
        if (path.length == 1) {
            strategy.getter(path[0])
        } else {
            strategy.getter(Arrays.asList(path))
        }
    }

    protected String addVarDeclaration(String fieldName, ClassCd fieldType, String fieldExp) {
        strategy.addVarDeclaration(fieldName, fieldType, fieldExp)
    }

    protected String transform(ClassCd toType, FieldCm from) {
        strategy.makeTransformation(toType, [from])
    }

}
