/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.dto

import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.metamodel.data.DataSchema

import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_DTO
import static pl.metaprogramming.codemodel.builder.java.MetaModelAttribute.JAVA_NAME

class RawDtoBuildStrategy extends BaseDtoBuildStrategy {

    private boolean withDescriptiveFields = true

    @Override
    void addField(DataSchema schema) {
        def fieldCm = new FieldCm(
                name: schema.getAdditive(JAVA_NAME),
                model: schema,
                type: getClass(REST_DTO, schema.dataType))
        if (withDescriptiveFields) {
            addDescriptiveFields(schema, fieldCm)
        }
        addFields(fieldCm)
    }

}
