/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.config


import pl.metaprogramming.codemodel.builder.java.module.SpringWsOutAdapterBuilder
import pl.metaprogramming.codemodel.builder.java.spring.WsClientBuildStrategy
import pl.metaprogramming.codemodel.builder.java.spring.WsClientConfigurationBuildStrategy
import pl.metaprogramming.codemodel.builder.java.xml.XmlDtoBuildStrategy
import pl.metaprogramming.codemodel.builder.java.xml.XmlEnumBuildStrategy
import pl.metaprogramming.codemodel.builder.java.xml.XmlObjectFactoryBuildStrategy
import pl.metaprogramming.metamodel.wsdl.WsdlApi

import static pl.metaprogramming.codemodel.builder.java.ClassType.*

class SpringWsOutAdapterConfigurator extends JavaModuleConfigurator<SpringWsOutAdapterConfigurator> {

    SpringWsOutAdapterConfigurator(CodegenParams params = new CodegenParams()) {
        super(params.withIfNotSet(new SpringWsParams()))
        init()
    }

    SpringWsOutAdapterBuilder makeBuilder(String moduleName, WsdlApi moduleModel) {
        new SpringWsOutAdapterBuilder(moduleName, moduleModel, moduleConfig)
    }

    private init() {
        addClass(XML_ENUM, '', new XmlEnumBuildStrategy())
        addClass(XML_OBJECT_FACTORY, '', new XmlObjectFactoryBuildStrategy())
        addLombokData(XML_DTO, '', new XmlDtoBuildStrategy())
        addClass(WS_CLIENT, 'Client', new WsClientBuildStrategy())
        addClass(WS_CLIENT_CONFIGURATION, 'ClientConfiguration', new WsClientConfigurationBuildStrategy(), diStrategy)
        this
    }

    SpringWsOutAdapterConfigurator setNamespacePackage(String namespace, String packageName) {
        params.get(SpringWsParams).namespace2Package[namespace] = packageName
        this
    }
}
