/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.base

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.ClassCm
import pl.metaprogramming.codemodel.model.java.JavaDefs
import pl.metaprogramming.codemodel.model.java.MethodCm

class InterfaceBuildStrategy extends ClassCmBuildStrategy {

    private Object implClassType

    InterfaceBuildStrategy(Object implClassType) {
        this.implClassType = implClassType
    }

    @Override
    void makeImplementation() {
        setInterface()
        def implClass = getClass(implClassType) as ClassCm
        implClass.interfaces.add(classModel)
        implClass.methods.findAll {
            it.public && !it.constructor
        }.each {
            addMappers(new MethodCm(
                    name: it.name,
                    resultType: it.resultType,
                    params: it.params,
                    description: it.description
            ))
            it.description = null
            it.annotations.add(JavaDefs.ANNOT_OVERRIDE)
        }
    }
}
