/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.base

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm

import static pl.metaprogramming.codemodel.model.java.JavaDefs.*

class EnumValueInterfaceBuilder extends ClassCmBuildStrategy {

    @Override
    void makeImplementation() {
        ClassCd genericType = new ClassCd(className: 'T', isGeneric: true, extend: classModel)
        setInterface()
        addMethods(
                new MethodCm(
                        name: 'getValue',
                        resultType: T_STRING),
                new MethodCm(
                        name: 'equalsValue',
                        modifiers: MODIFIER_DEFAULT,
                        resultType: T_BOOLEAN_PRIMITIVE,
                        params: [new FieldCm(T_STRING, 'value')],
                        implBody: "return getValue().equals(value);"
                ),
                new MethodCm(
                        name: 'fromValue',
                        modifiers: MODIFIER_STATIC,
                        resultType: genericType,
                        params: [new FieldCm(T_STRING, 'value'), new FieldCm(CLASS_T, 'enumClass')],
                        implBody: fromValueImplBody()
                )
        )
    }

    private String fromValueImplBody() {
        codeBuf.ifBlock("value == null", "return null;")
                .endBlock()
                .block("for (T e : enumClass.getEnumConstants())",
                        'if (e.equalsValue(value)) return e;')
                .endBlock()
                .addLines("throw new IllegalArgumentException(String.format(\"Unknown value '%s' of enum '%s'\", value, enumClass.getCanonicalName()));")
                .take()
    }
}
