/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.base

import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm

import static pl.metaprogramming.codemodel.builder.java.ClassType.ENUM_VALUE_INTERFACE
import static pl.metaprogramming.codemodel.model.java.JavaDefs.MODIFIER_PUBLIC_STATIC
import static pl.metaprogramming.codemodel.model.java.JavaDefs.T_STRING

class EnumBuildStrategy extends BaseEnumBuildStrategy {

    @Override
    void makeDeclaration() {
        ClassCd enumInterface = getClass(ENUM_VALUE_INTERFACE)
        addInterfaces(enumInterface)
        setEnums(model.allowedValues.collect { toItem(it) })
        addMappers new MethodCm(
                name: 'fromValue',
                resultType: classModel,
                modifiers: MODIFIER_PUBLIC_STATIC,
                params: [new FieldCm(T_STRING, 'value')],
                implBody: "return ${enumInterface.className}.fromValue(value, ${classModel.className}.class);"
        )
    }

}
