/*
 * Copyright (c) 2018 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.groovy.spock

class SpockRestServicesTestsMapperConfig {
    String destCodeDir
    String testPackage
    String clientClassName
    String clientTemplate
    String specTemplate

    SpockRestServicesTestsMapperConfig(Map<String, String> params) {
        destCodeDir = "${params.destProjectDir}/src/main/groovy"
        testPackage = params.testPackage
        clientClassName = params.clientClassName ?: 'RestClient'
        clientTemplate = params.clientTemplate ?: '/pl/metaprogramming/codegen/groovy/RestClient.groovy.gsp'
        specTemplate = params.specTemplate ?: '/pl/metaprogramming/codegen/groovy/SpockSpec.groovy.gsp'
    }
}
