/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codegen.validation

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm

import static pl.metaprogramming.codemodel.builder.java.ClassType.VALIDATION_CHECKER
import static pl.metaprogramming.codemodel.builder.java.ClassType.VALIDATION_DICTIONARY_CODES_ENUM
import static pl.metaprogramming.codemodel.builder.java.ClassType.VALIDATION_INVALID_CODES_ENUM
import static pl.metaprogramming.codemodel.model.java.JavaDefs.T_STRING

class DictionaryCheckerBuildStrategy extends ClassCmBuildStrategy {

    @Override
    void makeDeclaration() {
        def mapperResult = findClass(VALIDATION_CHECKER).withGeneric(T_STRING)
        addMappers(
                new MethodCm(
                        name: 'check',
                        resultType: mapperResult,
                        params: [makeDictCodeField(), makeInvalidCodeField()],
                        implBody: stubImplBody
                ),
                new MethodCm(
                        name: 'check',
                        resultType: mapperResult,
                        params: [makeDictCodeField()],
                        implBody: stubImplBody
                )
        )
    }

    private FieldCm makeDictCodeField() {
        new FieldCm(findClass(VALIDATION_DICTIONARY_CODES_ENUM), 'code')
    }

    private FieldCm makeInvalidCodeField() {
        new FieldCm(findClass(VALIDATION_INVALID_CODES_ENUM), 'invalidCode')
    }

    private String getStubImplBody() {
        'return ctx -> { /* TODO implement me */ };'
    }
}
