/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codegen.spring.rs.builders

import pl.metaprogramming.codegen.spring.rs.ResponseClassResolver
import pl.metaprogramming.codegen.spring.rs.TypeOfCode
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm
import pl.metaprogramming.metamodel.oas.Operation

import static pl.metaprogramming.codemodel.builder.java.spring.SpringDefs.ANNOT_SCOPE_PROTOTYPE
import static pl.metaprogramming.codemodel.builder.java.spring.SpringDefs.ANNOT_SERVICE
import static pl.metaprogramming.codemodel.model.java.JavaDefs.ANNOT_NON_NULL

class OperationExecutorBuildStrategy extends ClassCmBuildStrategy<Operation> {

    @Override
    void makeImplementation() {
        addAnnotations([ANNOT_SERVICE, ANNOT_SCOPE_PROTOTYPE])
        def responseClass = ResponseClassResolver.resolve(this, model)
        addMethods new MethodCm(
                name: 'execute',
                description: model.description,
                resultType: responseClass,
                params: [new FieldCm(name: 'request', type: getClass(TypeOfCode.REQUEST_DTO, model), annotations: [ANNOT_NON_NULL])],
                implBody: responseClass.isVoid() ? '' : 'return null;'
        )
    }
}
