/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codegen.spring.rs.builders

import pl.metaprogramming.codemodel.builder.java.base.BaseEnumBuildStrategy

import static pl.metaprogramming.codemodel.builder.java.ClassType.ENUM_VALUE_INTERFACE
import static pl.metaprogramming.codemodel.model.java.JavaDefs.Jackson.JSON_VALUE

class EnumBuildStrategy extends BaseEnumBuildStrategy {

    @Override
    void makeImplementation() {
        super.makeImplementation()
        classModel.fields[0].annotations.add(JSON_VALUE)
        addInterfaces(getClass(ENUM_VALUE_INTERFACE))
    }
}
