/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codegen.spring.rs

import pl.metaprogramming.codemodel.builder.java.config.JavaModuleConfig
import pl.metaprogramming.codemodel.builder.java.module.JavaModuleBuilder
import pl.metaprogramming.codemodel.formatter.JavaCodeFormatter
import pl.metaprogramming.metamodel.oas.RestApi

import static pl.metaprogramming.codegen.spring.rs.TypeOfCode.*

class SpringRestClientsBuilder extends JavaModuleBuilder<RestApi> {

    SpringRestClientsBuilder(String moduleName, RestApi moduleModel, JavaModuleConfig config) {
        super(moduleName, moduleModel, config, CLASS_TYPE_BUILD_ORDER)
    }

    @Override
    void make() {
        addSchemaCodes(model)
        addOperationCodes(model)
        makeCodeModels()
    }

    void addSchemaCodes(RestApi model) {
        model.schemas.each { schema ->
            if (schema.isEnum()) {
                addClass(ENUM, schema)
            }
            if (schema.isObject()) {
                addClass(DTO, schema)
            }
        }
    }

    void addOperationCodes(RestApi model) {
        model.groupedOperations.each { group, operations ->
            String javaGroupName = JavaCodeFormatter.toCapitalizeJavaName(group)
            operations.each { operation ->
                String dataName = operation.code.capitalize()
                addClass(REQUEST_DTO, operation, dataName)
            }
            [CLIENT_IMPL, CLIENT].each { classType ->
                addClass(classType, operations, javaGroupName)
            }
        }
    }

    private static final List CLASS_TYPE_BUILD_ORDER = [
            ENUM,
            DTO,
            REQUEST_DTO,
            CLIENT_IMPL,
            CLIENT,
    ]
}
