<%
 def cm = d.classCd;
%>package ${cm.packageName};

import lombok.Getter;

import javax.annotation.Generated;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@Generated("pl.metaprogramming.codegen")
public class ValidationContext<I> {

    @Getter private ValidationContext<?> parent;
    @Getter private ValidationResult result;
    @Getter private I value;
    @Getter private String name;

    private Map<Object, Object> requestScope;

    ValidationContext(I value) {
        this.value = value;
        this.result = new ValidationResult();
    }

    ValidationContext(I value, String name, ValidationContext<?> parent) {
        this.parent = parent;
        this.result = parent.result;
        this.value = value;
        this.name = name;
    }

    protected String getChildName(String childName) {
        return name == null || "requestBody".equals(name) ? childName : (name + "." + childName);
    }

    public boolean isValid() {
        return result.isValid();
    }

    public <T> T getBean(Class<T> beanClass) {
        if (requestScope != null && requestScope.containsKey(beanClass)) {
            return beanClass.cast(requestScope.get(beanClass));
        }
        if (parent != null) {
            return parent.getBean(beanClass);
        }
        throw new IllegalStateException("No validation bean " + beanClass);
    }


    public <T> void setBean(Class<T> beanClass, Function<ValidationContext<I>,T> beanCreator) {
        if (requestScope == null) {
            requestScope = new HashMap<>();
        }
        requestScope.put(beanClass, beanCreator.apply(this));
    }

    @SafeVarargs
    public final void check(Checker<I>...checkers) {
        if (isValid()) {
            for (Checker<I> checker : checkers) {
                if (!isValid()) {
                    break;
                }
                if (value != null || checker.checkNull()) {
                    checker.check(this);
                }
            }
        }
    }

    @SafeVarargs
    public final <T> void check(Field<I,T> field, Checker<T>...checkers) {
        getChild(field).check(checkers);
    }

    public <T> ValidationContext<T> getChild(Field<I,T> field) {
        return new ValidationContext<>(field.getValue(getValue()), getChildName(field.getName()), this);
    }
}
