<%
 def cm = d.classCd;
%>package ${cm.packageName};

import ${d.ENUM_VALUE_INTERFACE.canonicalName};

import javax.annotation.Generated;
import java.util.*;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Generated("pl.metaprogramming.codegen")
public class CommonCheckers {

    // see https://www.debuggex.com/r/_G6Mvw1eoYJF2Bgf
    private static String DATE_REGEX = "(?:[1-9]\\\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)";
    private static String TIME_REGEX = "(?:[01]\\\\d|2[0-3]):[0-5]\\\\d:[0-5]\\\\d(?:|.\\\\d+)(?:Z|[+-][01]\\\\d:[0-5]\\\\d)";
    private static Pattern ISO8601_DATE_TIME_PATTERN = Pattern.compile(String.format("^%sT%s\$", DATE_REGEX, TIME_REGEX));
    private static Pattern ISO8601_DATE_PATTERN = Pattern.compile(String.format("^%s\$", DATE_REGEX));

    public interface DangerousConsumer<T> {
        void accept(T value) throws Exception;
    }

    public static void writeError(ValidationContext<?> ctx, String message) {
        ctx.getResult().setError(400, message);
    }

    public static boolean isNull(Object value) {
        return value == null;
    }

    public static boolean isNotNull(Object value) {
        return !isNull(value);
    }

    public static boolean isNoException(String value, DangerousConsumer<String> consumer) {
        try {
            consumer.accept(value);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public static Checker<String> noException(DangerousConsumer<String> consumer, String dataType) {
        return new SimpleChecker<>(
                ctx -> isNoException(ctx.getValue(), consumer),
                ctx -> writeError(ctx, String.format("%s is not %s", ctx.getName(), dataType)));
    }

    @SafeVarargs
    public static <T> Checker<List<T>> list(Checker<T>...checkers) {
        return context -> {
            for (int idx = 0; idx < context.getValue().size() && context.isValid(); idx++) {
                new ValidationContext<>(
                        context.getValue().get(idx),
                        String.format("%s[%d]", context.getName(), idx),
                        context).check(checkers);
            }
        };
    }

    @SafeVarargs
    public static <T> Checker<Map<String,T>> mapValues(Checker<T>...checkers) {
        return context -> {
            Iterator<String> keys = context.getValue().keySet().iterator();
            while (keys.hasNext() && context.isValid()) {
                String key = keys.next();
                new ValidationContext<>(
                        context.getValue().get(key),
                        String.format("%s[%s]", context.getName(), key),
                        context).check(checkers);
            }
        };
    }

    public static Checker<String> allow(EnumValue...values) {
        return allow(Stream.of(values).map(EnumValue::getValue).collect(Collectors.toList()));
    }

    public static Checker<String> allow(Collection<String> allowedValues) {
        return new SimpleChecker<>(
                ctx -> allowedValues.contains(ctx.getValue()),
                ctx -> writeError(ctx, ctx.getName() + " should have one of values: " + allowedValues));
    }

    public static Checker<String> allow(Collection<String> allowedValues, Function<String,String> preprocessor) {
        return new SimpleChecker<>(
                ctx -> allowedValues.contains(preprocessor.apply(ctx.getValue())),
                ctx -> writeError(ctx, ctx.getName() + " should have one of values: " + allowedValues));
    }

    public static Checker<String> matches(Pattern pattern) {
        return matches(pattern, "should match pattern: " + pattern.pattern());
    }

    public static Checker<String> matches(Pattern pattern, String errorMessage) {
        return new SimpleChecker<>(
                ctx -> pattern.matcher(ctx.getValue()).matches(),
                ctx -> writeError(ctx, ctx.getName() + " " + errorMessage));
    }

    public static <T> Checker<List<T>> size(Integer minSize, Integer maxSize) {
        return new SimpleChecker<>(
                ctx -> (minSize == null || minSize <= ctx.getValue().size()) &&
                        (maxSize == null || maxSize >= ctx.getValue().size()),
                ctx -> writeError(ctx, ctx.getName() + " " +
                                (minSize != null && minSize >= ctx.getValue().size() ?
                                        ("has not enough elements, min allowed size is " + minSize) :
                                        ("hast too many elements, max allowed size is " + maxSize))));
    }

    public static Checker<String> length(Integer minLength, Integer maxLength) {
        return new SimpleChecker<>(
                ctx -> (minLength == null || minLength <= ctx.getValue().length()) &&
                        (maxLength == null || maxLength >= ctx.getValue().length()),
                ctx -> writeError(ctx, ctx.getName() +
                        (minLength != null && minLength >= ctx.getValue().length() ?
                                (" has too short value, min allowed length is " + minLength) :
                                (" has too long value, max allowed length is " + maxLength))));
    }

    public static <T extends Comparable<T>> Checker<String> range(Function<String,T> mapper, String minValue, String maxValue) {
        final T min = minValue != null ? mapper.apply(minValue) : null;
        final T max = maxValue != null ? mapper.apply(maxValue) : null;
        final String message = " should be " +
                (minValue != null && maxValue != null ? (">= " + minValue + " and <= " + maxValue)
                : minValue != null ? (">= " + minValue) : ("<= " + maxValue));
        return new SimpleChecker<>(
                ctx -> {
                    T value = mapper.apply(ctx.getValue());
                    return (minValue == null || min.compareTo(value) <= 0) &&
                            (maxValue == null || max.compareTo(value) >= 0);
                },
                ctx -> writeError(ctx, ctx.getName() + message));
    }

    public static <T extends Comparable<T>, P> Checker<P> gt(Field<P, String> field1, Field<P, String> field2, Function<String, T> mapper) {
        return compare(field1, field2, mapper, c -> c > 0, "%s should be greater than %s");
    }

    public static <T extends Comparable<T>, P> Checker<P> ge(Field<P, String> field1, Field<P, String> field2, Function<String, T> mapper) {
        return compare(field1, field2, mapper, c -> c >= 0, "%s should be greater equal than %s");
    }

    public static <T extends Comparable<T>, P> Checker<P> lt(Field<P, String> field1, Field<P, String> field2, Function<String, T> mapper) {
        return compare(field1, field2, mapper, c -> c < 0, "%s should be less than %s");
    }

    public static <T extends Comparable<T>, P> Checker<P> le(Field<P, String> field1, Field<P, String> field2, Function<String, T> mapper) {
        return compare(field1, field2, mapper, c -> c <= 0, "%s should be less equal than %s");
    }

    public static <T extends Comparable<T>, P> Checker<P> eq(Field<P, String> field1, Field<P, String> field2, Function<String, T> mapper) {
        return compare(field1, field2, mapper, c -> c == 0, "%s should be the same as %s");
    }

    public static <T extends Comparable<T>, P> Checker<P> compare(
            Field<P, String> field1,
            Field<P, String> field2,
            Function<String, T> mapper,
            Function<Integer, Boolean> isComparisonValid,
            String messageTemplate
    ) {
        return new SimpleChecker<>(
                ctx -> {
                    String value1 = field1.getValue(ctx.getValue());
                    String value2 = field2.getValue(ctx.getValue());
                    return value1 == null || value2 == null
                            || isComparisonValid.apply(mapper.apply(value1).compareTo(mapper.apply(value2)));
                },
                ctx -> writeError(ctx, String.format(messageTemplate, field1.getName(), field2.getName())));
    }


    @SuppressWarnings("unchecked")
    public static <T> Checker<T> required() {
        return (Checker<T>) REQUIRED;
    }

    @SuppressWarnings("unchecked")
    public static <T> Checker<T> notAllowed() {
        return (Checker<T>) NOT_ALLOWED;
    }

    public static final Checker<Object> REQUIRED = new SimpleChecker<>(
            ctx -> isNotNull(ctx.getValue()),
            ctx -> writeError(ctx,ctx.getName() + " is required"),
            true);

    public static final Checker<Object> NOT_ALLOWED = new SimpleChecker<>(
            ctx -> isNull(ctx.getValue()),
            ctx -> writeError(ctx,ctx.getName() + " is not allowed"));

    public static final Checker<String> BOOLEAN = allow(Arrays.asList("true", "false"), String::toLowerCase);

    public static final Checker<String> INT32 = noException(Integer::parseInt, "32bit integer");

    public static final Checker<String> INT64 = noException(Long::parseLong, "64bit integer");

    public static final Checker<String> FLOAT = noException(Float::parseFloat, "float");

    public static final Checker<String> DOUBLE = noException(Double::parseDouble, "double");

    public static final Checker<String> ISO_DATE = matches(ISO8601_DATE_PATTERN, "is not yyyy-MM-dd");

    public static final Checker<String> ISO_DATE_TIME = matches(ISO8601_DATE_TIME_PATTERN, "should be valid date time in ISO8601 format");
}
