<% def cm = (pl.metaprogramming.codemodel.model.groovy.SpockRestSpecCm) d; %>package ${cm.packageName}

import javax.annotation.Generated
import spock.lang.Specification
import spock.lang.Unroll

import static ${cm.restClientClass}.*

@Generated("pl.metaprogramming.codegen")
class ${cm.className} extends Specification {

    @Unroll
    def "${cm.operationCode} - #status - #reqMod"() {
        when:
        def result = call(status, reqMod)

        then:
        result != null
        result.status == status

        where:
        status   | reqMod | response <% cm.responseStatuses.each { statusCode -> %>
        ${statusCode} | [:] | null<%}%>
    }

    static Object call(def reqData, Map reqMod) {
        def m = modifyRequest(getReqData(reqData), reqMod)
        client.${cm.operationType}(
                path: getPath(m),
                headers: getHeaders(m),
                query: getQuery(m),
                <% if (cm.hasBody) {%>body: getBody(m),<%}%>
        )
    }

    static String getPath(Map m) {
        <% if (cm.pathParams.size() > 0) {%>preparePath('${cm.path}', [<%cm.pathParams.each {%>
                    ${it}: m['${it}'],
        <%}%>])<%} else { %> '${cm.path}' <%}%>
    }

    static Map getHeaders(Map m) {
        <% if (cm.headerParams.size() > 0) {%>[<%cm.headerParams.each {%>
                ${it}: m['${it}'],
        <%}%>]<%} else {%>null<%}%>
    }

    static Map getQuery(Map m) {
        <% if (cm.queryParams.size() > 0) {%>[<%cm.queryParams.each {%>
                ${it}: m['${it}'],
        <%}%>]<%} else {%>null<%}%>
    }

    <% if (cm.hasBody) {%>static Map getBody(Map m) {
        <% if (cm.requestTemplate.requestBody) { %>m.requestBody
        <% } else {%>def exclude = ['${(cm.headerParams + cm.pathParams + cm.queryParams).join("', '")}']
        m.findAll { !exclude.contains(it.key) }<%}%>
    }<%}%>

    static Map getReqData(def reqData) {
        switch (reqData) {<%cm.responseStatuses.each {%>
        case ${it}:
            return ${cm.requestTemplate}<%}%>
        }
        ${cm.requestTemplate}
    }

    static Map modifyRequest(Map request, Map reqMod) {
        request << reqMod
    }
}