<% def cm = (pl.metaprogramming.codemodel.model.java.ClassCm) d; %>package ${cm.packageName}

import groovyx.net.http.RESTClient
import javax.annotation.Generated
import org.apache.http.HttpHost
import org.apache.http.HttpRequest
import org.apache.http.client.ClientProtocolException
import org.apache.http.client.ResponseHandler
import org.apache.http.entity.BufferedHttpEntity
import org.apache.http.impl.client.DefaultHttpClient
import org.apache.http.protocol.HttpContext

@Generated("pl.metaprogramming.codegen")
class ${cm.className} {
    def static client = getRestClient('http://127.0.0.1:8080/')

    def static getRestClient(def uri) {
        def client = new RESTClient(uri)
        client.setClient(new DefaultHttpClient() {
            @Override
            <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
                println "HTTP \$request.method \${request.URI} HEADERS: \$request.allHeaders"
                if (request.method == 'POST' && request.entity != null) {
                    println request.entity.content.text
                }
                (T) super.execute(target, request, {response ->
                    response.setEntity(new BufferedHttpEntity(response.getEntity()))
                    println "HTTP \$response.statusLine.statusCode HEADERS: \$response.allHeaders"
                    if (response.entity.content.text) {
                        println response.entity.content.text
                    }
                    responseHandler.handleResponse(response)
                }, context)
            }
        })

        client.setContentType('application/json')
        client.handler.failure = client.handler.success
        client
    }

    static String preparePath(String path, Map params) {
        def result = path
        path.findAll("\\\\{[^\\\\}]*\\\\}").each {
            result = result.replace(it, ''+params.get(it.substring(1, it.length()-1)))
        }
        result
    }

}
