/*
 * Decompiled with CFR 0.152.
 */
package pl.metaprogramming.metamodel.oas;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import pl.metaprogramming.metamodel.oas.Operation;
import pl.metaprogramming.metamodel.oas.OperationType;
import pl.metaprogramming.metamodel.oas.ParamLocation;
import pl.metaprogramming.metamodel.oas.Parameter;

public class RestApiModelChecker
implements GroovyObject {
    private static final String SUB_SCHEMA = "Schema";
    private static final String SUB_PARAM = "Parameter";
    private static final String SUB_OPID = "OperationId";
    private static final String SUB_PATH = "Path";
    private static final String SUB_REQS = "requestBody";
    private static final List<OperationType> OPERATIONS_WITH_BODY;
    private static final Set<String> JAVA_KEYWORDS;
    private boolean isOas2;
    private String currentOperation;
    private Set<String> operations;
    private Set<String> paths;
    private Set<String> dataSchemas;
    private Set<String> params;
    private List<String> warnings;
    private boolean weekValidation;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public RestApiModelChecker() {
        MetaClass metaClass;
        boolean bl;
        List list;
        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.operations = (Set)ScriptBytecodeAdapter.castToType((Object)list2, Set.class);
        List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.paths = (Set)ScriptBytecodeAdapter.castToType((Object)list3, Set.class);
        List list4 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.dataSchemas = (Set)ScriptBytecodeAdapter.castToType((Object)list4, Set.class);
        List list5 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.params = (Set)ScriptBytecodeAdapter.castToType((Object)list5, Set.class);
        this.warnings = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.weekValidation = bl = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void checkDataCode(String code) {
        this.addUnique(SUB_SCHEMA, this.dataSchemas, code);
    }

    public void checkCommonParamCode(String code) {
        this.addUnique(SUB_PARAM, this.params, code);
    }

    public void checkOperationNames(Operation operation) {
        this.checkName(operation.getGroup(), "group");
        this.checkName(operation.getCode(), "operationId");
    }

    public void checkOperation(Operation operation) {
        String string;
        Object var2_2 = null;
        this.currentOperation = ShortTypeHandling.castToString(var2_2);
        this.addUnique(SUB_OPID, this.operations, operation.getCode());
        this.currentOperation = string = operation.getCode();
        this.addUnique(SUB_PATH, this.paths, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{operation.getPath(), operation.getType()}, new String[]{"", ".", ""})));
        this.checkPathParameters(operation);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)operation.getType()), (Object)((Object)OperationType.POST))) {
            this.requiredElseEmpty(RestApiModelChecker.shouldHaveBodyParam(operation), operation.getRequestBodySchema(), SUB_REQS);
        }
    }

    public void checkPathParameters(Operation operation) {
        public final class _checkPathParameters_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _checkPathParameters_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((String)it).substring(1, ((String)it).length() - 1);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkPathParameters_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List pathParams = DefaultGroovyMethods.sort((Iterable)DefaultGroovyMethods.collect((Iterable)StringGroovyMethods.findAll((CharSequence)operation.getPath(), (CharSequence)"\\{[^\\}]*\\}"), (Closure)new _checkPathParameters_closure1(this, this)));
        public final class _checkPathParameters_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _checkPathParameters_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Object)ParamLocation.PATH), (Object)((Object)((Parameter)it).getLocation()));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkPathParameters_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _checkPathParameters_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _checkPathParameters_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Parameter)it).getName();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkPathParameters_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List declaredPathParams = DefaultGroovyMethods.sort((Iterable)DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll(operation.getParameters(), (Closure)new _checkPathParameters_closure2(this, this)), (Closure)new _checkPathParameters_closure3(this, this)));
        this.check(ScriptBytecodeAdapter.compareEqual((Object)pathParams, (Object)declaredPathParams), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{operation.getPath(), declaredPathParams}, new String[]{"Mismatch between path value [", "] and declared path parameters ", ""})));
    }

    private String addCtxToMsg(String msg) {
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)this.currentOperation) ? new GStringImpl(new Object[]{msg, this.currentOperation}, new String[]{"", " [for operation ", "]"}) : msg));
    }

    private void addUnique(String subject, Set<String> set, String code) {
        this.check(code != null && !code.isEmpty(), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{subject, code}, new String[]{"", ": '", "' should not be empty"})));
        this.check(!set.contains(code), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{subject, code}, new String[]{"", ": '", "' is already used"})));
        set.add(code);
    }

    public void requiredElseEmpty(boolean required, Object value, String subject) {
        if (required) {
            this.check(value != null, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{subject}, new String[]{"", " is required"})), ShortTypeHandling.castToString((Object)(this.weekValidation ? new GStringImpl(new Object[]{subject}, new String[]{"", " should be present"}) : null)));
        } else {
            this.check(value == null, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{subject}, new String[]{"", " must be empty"})));
        }
    }

    public void check(boolean condition, String invalidMessage, String warnMessage) {
        if (DefaultTypeTransformation.booleanUnbox((Object)warnMessage) && !condition) {
            this.warnings.add(warnMessage);
            DefaultGroovyMethods.println((PrintStream)System.err, (Object)new GStringImpl(new Object[]{this.addCtxToMsg(warnMessage)}, new String[]{"[WARNING] ", ""}));
        } else if (!condition) {
            throw (Throwable)new IllegalStateException(this.addCtxToMsg(invalidMessage));
        }
    }

    private void checkName(String value, String valueName) {
        this.check(!JAVA_KEYWORDS.contains(value) && ScriptBytecodeAdapter.matchRegex((Object)value, (Object)"[a-zA-Z]+[a-zA-Z0-9_$]*"), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{valueName, value}, new String[]{"", " with value '", "' can't be use to generate valid code"})));
    }

    public static boolean shouldHaveBodyParam(Operation operation) {
        return RestApiModelChecker.isOperationWithBody(operation.getType()) && RestApiModelChecker.shouldHaveBodySchema(operation);
    }

    public static boolean shouldHaveBodySchema(Operation operation) {
        return !DefaultGroovyMethods.disjoint((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{"application/json", "application/xml"}), operation.getConsumes());
    }

    public static boolean isOperationWithBody(OperationType operationType) {
        return OPERATIONS_WITH_BODY.contains((Object)operationType);
    }

    @Generated
    public void check(boolean condition, String invalidMessage) {
        this.check(condition, invalidMessage, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RestApiModelChecker.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Set set;
        List list;
        OPERATIONS_WITH_BODY = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{OperationType.POST, OperationType.UPDATE, OperationType.PUT, OperationType.PATCH});
        JAVA_KEYWORDS = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"}), Set.class);
    }

    @Generated
    public boolean getIsOas2() {
        return this.isOas2;
    }

    @Generated
    public boolean isIsOas2() {
        return this.isOas2;
    }

    @Generated
    public void setIsOas2(boolean bl) {
        this.isOas2 = bl;
    }

    @Generated
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Generated
    public void setWarnings(List<String> list) {
        this.warnings = list;
    }

    @Generated
    public boolean getWeekValidation() {
        return this.weekValidation;
    }

    @Generated
    public boolean isWeekValidation() {
        return this.weekValidation;
    }

    @Generated
    public void setWeekValidation(boolean bl) {
        this.weekValidation = bl;
    }
}

