/*
 * Decompiled with CFR 0.152.
 */
package pl.metaprogramming.codemodel.builder.java.dto;

import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import pl.metaprogramming.codemodel.builder.java.ClassType;
import pl.metaprogramming.codemodel.builder.java.MetaModelAttribute;
import pl.metaprogramming.codemodel.builder.java.dto.BaseDtoBuildStrategy;
import pl.metaprogramming.codemodel.model.java.AnnotationCm;
import pl.metaprogramming.codemodel.model.java.ClassCd;
import pl.metaprogramming.codemodel.model.java.FieldCm;
import pl.metaprogramming.codemodel.model.java.ValueCm;
import pl.metaprogramming.metamodel.data.DataSchema;
import pl.metaprogramming.metamodel.data.DataType;

public class JsonDtoBuildStrategy
extends BaseDtoBuildStrategy {
    private static final String CLASS_ANNOTATION = "com.fasterxml.jackson.annotation.JsonAutoDetect";
    private static final String FIELD_ANNOTATION = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final AnnotationCm ANNOTATION;
    private static final AnnotationCm JSON_RAW_VALUE_ANNOTATION;
    private boolean withDescriptiveFields;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public JsonDtoBuildStrategy() {
        boolean bl;
        this.withDescriptiveFields = bl = true;
    }

    @Override
    public void makeImplementation() {
        super.makeImplementation();
        this.addAnnotation(ANNOTATION);
    }

    @Override
    public void addField(DataSchema schema) {
        FieldCm fieldCm = new FieldCm();
        DataSchema dataSchema = schema;
        fieldCm.setModel(dataSchema);
        String string = schema.getAdditive(MetaModelAttribute.getJAVA_NAME());
        fieldCm.setName(string);
        ClassCd classCd = this.getClass((Object)ClassType.REST_DTO, schema.getDataType());
        fieldCm.setType(classCd);
        List<AnnotationCm> list = this.createFieldAnnotations(schema);
        fieldCm.setAnnotations(list);
        FieldCm fieldCm2 = fieldCm;
        if (this.withDescriptiveFields) {
            this.addDescriptiveFields(schema, fieldCm2);
        }
        this.addFields(fieldCm2);
    }

    public List<AnnotationCm> createFieldAnnotations(DataSchema schema) {
        List result = ScriptBytecodeAdapter.createList((Object[])new Object[]{new AnnotationCm(FIELD_ANNOTATION, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", ValueCm.escaped(schema.getCode())}))});
        if (this.isNumberOrBoolean(schema.getBaseDataType())) {
            result.add(JSON_RAW_VALUE_ANNOTATION);
        }
        if (schema.isMap() && this.isNumberOrBoolean(schema.getMapType().getValuesSchema().getDataType())) {
            ClassCd serializer = this.getClass((Object)ClassType.MAP_RAW_VALUE_SERIALIZER);
            this.addImports(serializer);
            result.add(new AnnotationCm("com.fasterxml.jackson.databind.annotation.JsonSerialize", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"using", ValueCm.value(StringGroovyMethods.plus((String)serializer.getClassName(), (CharSequence)".class"))})));
        }
        return result;
    }

    public boolean isNumberOrBoolean(DataType dataType) {
        return ScriptBytecodeAdapter.compareEqual((Object)DataType.BOOLEAN, (Object)dataType) || DataType.NUMBER_TYPES.contains(dataType);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JsonDtoBuildStrategy.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        AnnotationCm annotationCm;
        AnnotationCm annotationCm2;
        ANNOTATION = annotationCm2 = new AnnotationCm(CLASS_ANNOTATION, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fieldVisibility", ValueCm.value("JsonAutoDetect.Visibility.NONE")}));
        JSON_RAW_VALUE_ANNOTATION = annotationCm = new AnnotationCm("com.fasterxml.jackson.annotation.JsonRawValue");
    }

    @Generated
    public static String getCLASS_ANNOTATION() {
        return CLASS_ANNOTATION;
    }

    @Generated
    public static String getFIELD_ANNOTATION() {
        return FIELD_ANNOTATION;
    }

    @Generated
    public static AnnotationCm getANNOTATION() {
        return ANNOTATION;
    }

    @Generated
    public static AnnotationCm getJSON_RAW_VALUE_ANNOTATION() {
        return JSON_RAW_VALUE_ANNOTATION;
    }
}

