/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.parser.wsdl

import groovy.xml.QName
import pl.metaprogramming.metamodel.model.data.DataType

class XsTypeParser implements DataTypeParser<QName> {

    static String XS_URI = 'http://www.w3.org/2001/XMLSchema'

    static Map<String, DataType> XS_TYPES = [
            'string'  : DataType.TEXT,
            'int'     : DataType.INT32,
            'integer' : DataType.INT32,
            'long'    : DataType.INT64,
            'decimal' : DataType.DECIMAL,
            'date'    : DataType.DATE_TIME,
            'dateTime': DataType.DATE_TIME,
    ]

    @Override
    DataType parse(QName qName) {
        if (qName.namespaceURI == XS_URI) {
            String xsType = qName.localPart
            assert XS_TYPES.containsKey(xsType)
            XS_TYPES[xsType]
        } else {
            null
        }
    }
}
