/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.parser.swagger

import pl.metaprogramming.metamodel.model.rest.Parameter
import pl.metaprogramming.metamodel.model.rest.RestApi

import java.util.function.Predicate

class SwaggerParserConfig {

    /*
     eg. pets: { path -> path.contain('/pets') }
     If not set x-swagger-router-controller or tags elements are used
     */
    Map<String, Predicate<String>> resourceResolvers

    /*
     Extensive logging
     */
    boolean verbose = false

    boolean weekValidation = false

    boolean partialFile = false

    List<RestApi> dependsOn = []

    /*
     Additional parameters to add to all operations from imported swagger
     */
    List<Parameter> additionalParameters = []
}
