/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.parser.swagger

import pl.metaprogramming.metamodel.builder.RestApiBuilder
import pl.metaprogramming.metamodel.model.rest.RestApi

class SwaggerParser extends BaseParser {

    private DefinitionsParser definitionsParser
    private ParametersParser parametersParser
    private OperationsParser operationsParser
    private EnumParser enumParser

    SwaggerParser(Map spec, SwaggerParserConfig config = new SwaggerParserConfig()) {
        this.spec = spec
        this.config = config
        builder = new RestApiBuilder()
        builder.dependsOn(config.dependsOn)
        builder.checker.weekValidation = config.weekValidation
        enumParser = new EnumParser(this)
        definitionsParser = new DefinitionsParser(this, enumParser)
        parametersParser = new ParametersParser(this, definitionsParser)
        operationsParser = new OperationsParser(this, definitionsParser, parametersParser)

    }

    RestApi read() {
        if (!config.partialFile) {
            assert spec['swagger'] == '2.0'
        }
        definitionsParser.readDefinitions()
        parametersParser.readParameters()
        operationsParser.readOperations()
        enumParser.addEnums()
        builder.model
    }

    def getWarnings() {
        builder.checker.warnings
    }
}
