/*
/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.parser.swagger

import pl.metaprogramming.metamodel.model.data.DataSchema
import pl.metaprogramming.metamodel.model.rest.Parameter
import pl.metaprogramming.metamodel.model.rest.enums.ParamLocation

class ParametersParser extends BaseParser {

    static final String PARAMS_SECTION = '#/parameters/'

    DefinitionsParser definitionsParser

    ParametersParser(BaseParser template, DefinitionsParser definitionsParser) {
        configure(template)
        this.definitionsParser = definitionsParser
    }

    void readParameters() {
        log "Going to parse parameters..."
        (spec[PARAMETERS] as Map<String,Map>)?.each { code, spec ->
            log "  $code"
            def paramDef = toParameter(spec, code)
            builder.paramDef(code, paramDef)
        }
        config.additionalParameters.each {
            builder.paramDef(it.code, it)
        }
    }

    Parameter toParameter(Map spec, String code = null) {
        def paramDef = definitionsParser.fillDataSchema(new Parameter(
                name: (String) spec.name,
                code: code,
                location: getParamLocation(spec),
                isRequired: Boolean.TRUE == spec.required
        ), spec)
        fixEnumCode(paramDef, paramDef.code)
        paramDef
    }

    static ParamLocation getParamLocation(Map paramSpec) {
        ParamLocation.valueOf(((String) paramSpec.in).toUpperCase())
    }

    static String getNameFromParamRef(Map spec) {
        String ref = (String) spec[REF]
        ref.substring(ref.indexOf(PARAMS_SECTION) + PARAMS_SECTION.length())
    }

    static DataSchema fixEnumCode(DataSchema schema, String code) {
        if (schema.isEnum()) {
            if (!schema.enumType.code) {
                schema.enumType.code = code
            }
        } else if (schema.isArray()) {
            fixEnumCode(schema.arrayType.itemsSchema, code)
        }
        schema
    }

}
