/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.parser.swagger

import pl.metaprogramming.metamodel.builder.RestApiBuilder

class BaseParser {

    public static final String REF = '$ref'
    public static final String PROPERTIES = 'properties'
    public static final String PARAMETERS = 'parameters'

    Map spec
    RestApiBuilder builder
    SwaggerParserConfig config
    List<String> externalSchemas = []

    void configure(BaseParser template) {
        spec = template.spec
        builder = template.builder
        config = template.config
        config.dependsOn.collect {
            externalSchemas.addAll(it.schemas.keySet())
        }
    }

    void log(String message) {
        if (config.verbose) {
            println message
        }
    }

    void check(boolean condition, String invalidMessage, String warnMessage = null) {
        builder.checker.check(condition, invalidMessage, warnMessage)
    }


}
