/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.parser

import groovy.json.JsonSlurper
import org.yaml.snakeyaml.Yaml

class FileReader {

    static Map readFromClasspath(String path) {
        def stream = FileReader.class.getResource(path).newInputStream()
        if (path.toLowerCase().endsWith('.json')) {
            return readJson(stream)
        } else if (path.toLowerCase().endsWith('.yaml')) {
            return readYaml(stream)
        }
        throw new RuntimeException("Can't determine file type (json/yaml) for $path")
    }

    static Map readYaml(InputStream is) {
        Yaml parser = new Yaml()
        parser.load(is)
    }

    static Map readJson(InputStream is) {
        def jsonSlurper = new JsonSlurper()
        (Map) jsonSlurper.parse(is)
    }

}
