/*
 * Copyright (c) 2018 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.model.rest

import pl.metaprogramming.metamodel.model.data.ArrayType
import pl.metaprogramming.metamodel.model.data.DataSchema
import pl.metaprogramming.metamodel.model.data.DataType
import pl.metaprogramming.metamodel.model.data.MapType
import pl.metaprogramming.metamodel.model.data.ObjectType

class RestApi {

    // resource -> (operationCode -> operationModel)
    Map<String, Map<String, Operation>> operations = [:]

    Map<String, DataSchema> schemas = [:]
    Map<String, Parameter> parameters = [:]
    Map<Integer, HttpResponse> responses = [:]
    List<String> consumes = ['application/json']
    List<String> produces = ['application/json']

    List<RestApi> dependsOn = []

    Set<ObjectType> getInputObjects() {
        def result = [] as Set
        operations.values().each {
            it.values().each {
                collectObjectTypes(result, it.requestBody)
                it.parameters.each { collectObjectTypes(result, it.dataType) }
            }
        }
        result
    }

    def collectObjectTypes(Set<ObjectType> result, DataType dataType) {
        if (dataType instanceof ObjectType) {
            result.add((ObjectType) dataType)
            dataType.inherits.each { collectObjectTypes(result, it) }
            dataType.fields.each { collectObjectTypes(result, it.dataType) }
        } else if (dataType instanceof ArrayType) {
            collectObjectTypes(result, dataType.itemsSchema.dataType)
        } else if (dataType instanceof MapType) {
            collectObjectTypes(result, dataType.valuesSchema.dataType)
        }
    }
}
