/*
 * Copyright (c) 2018 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.model.rest

import groovy.transform.ToString
import pl.metaprogramming.metamodel.model.data.DataSchema
import pl.metaprogramming.metamodel.model.data.DataType
import pl.metaprogramming.metamodel.model.data.ObjectType
import pl.metaprogramming.metamodel.model.rest.enums.OperationType

@ToString(includes = ['code', 'type', 'path'], includePackage = false)
class Operation {
    String group
    String code
    String path
    OperationType type
    String description
    List<Parameter> parameters = []
    List<String> consumes
    List<String> produces
    DataType requestBody
    List<HttpResponse> responses

    ObjectType requestSchema

    def methodMissing(String methodName, Object...args) {
        if (this.hasProperty(methodName)) {
            this.setProperty(methodName, args[0])
        } else {
            throw new MissingMethodException(methodName, this.class, args)
        }
    }

    String getOperationId() {
        "${group.capitalize()}.${code}"
    }

    ObjectType getRequestSchema() {
        if (!requestSchema) {
            requestSchema = new ObjectType()
            if (requestBody) {
                requestSchema.fields.add(new DataSchema(code: 'requestBody', dataType: requestBody, isRequired: true))
            }
            parameters.each {
                requestSchema.fields.add(it)
            }
        }
        requestSchema
    }
}
