/*
 * Copyright (c) 2018 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.model.rest

import pl.metaprogramming.metamodel.model.data.DataSchema

class HttpResponse {
    int status
    String description
    String contentType
    DataSchema schema

    boolean isSuccessResponse() {
        return status >= 200 && status <= 206
    }

    String toString() {
        StringBuilder buf = new StringBuilder()
        buf.append(status == 0 ? 'default' : status)
        if (contentType) buf.append(' ').append(contentType)
        if (schema) buf.append(' ').append(schema.toString())
        buf.toString()
    }
}
