/*
 * Copyright (c) 2018 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.model.data

class ObjectType extends DataType {

    String code
    String namespace
    String description
    List<ObjectType> inherits = []
    List<DataSchema> fields = []

    boolean isRootElement

    ObjectType() {
        super(DataTypeCode.OBJECT)
    }

    String toString() {
        def attributes = []
        if(description) attributes.add("'$description'")
        attributes.addAll(getToStringAttributes())
        "$code OBJECT${attributes}"
    }

    List getToStringAttributes() {
        ['{' + "fields: $fields" + (inherits ? ", inherits: $inherits" : '') + '}']
    }

}
