/*
 * Copyright (c) 2018 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.model.data

import groovy.transform.ToString

@ToString(includeNames = true, ignoreNulls = true, includePackage = false, excludes = ['toStringAttributes'])
class EnumType extends DataType {
    String code
    // lista dozwolonych wartości dla enumeracji
    List<String> allowedValues
    // słownik, który zawiera dozwolone wartości
    String dictionaryRef
    Map<String,String> descriptions

    EnumType() {
        super(DataTypeCode.ENUM)
    }

    void setDescription(String value, String description) {
        assert allowedValues.contains(value)
        if (!descriptions) descriptions = [:]
        descriptions.put(value, description)
    }

    String getDescription(String value) {
        descriptions ? descriptions.get(value) : null
    }
}
