/*
 * Copyright (c) 2018 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.model.data

class DataType {

    public static final DataType BINARY = new DataType(DataTypeCode.BINARY)
    public static final DataType TEXT = new DataType(DataTypeCode.STRING)
    public static final DataType BOOLEAN = new DataType(DataTypeCode.BOOLEAN)
    public static final DataType DATE_TIME = new DataType(DataTypeCode.DATE_TIME)
    public static final DataType NUMBER = new DataType(DataTypeCode.NUMBER)
    public static final DataType INT32 = new DataType(DataTypeCode.INT32)
    public static final DataType INT64 = new DataType(DataTypeCode.INT64)
    public static final DataType DECIMAL = new DataType(DataTypeCode.DECIMAL)
    public static final DataType FLOAT = new DataType(DataTypeCode.FLOAT)
    public static final DataType DOUBLE = new DataType(DataTypeCode.DOUBLE)

    DataTypeCode typeCode

    protected DataType(DataTypeCode typeCode) {
        this.typeCode = typeCode
    }

    String toString() {
        return typeCode.toString()
    }

    List getToStringAttributes() {
        []
    }

}
