package pl.metaprogramming.metamodel.model.data

import java.util.function.Supplier

class DataSchema {

    /**
     * Nazwa kodowa danych.
     */
    String code

    /**
     * Namespace (xsd).
     * Raczej powinien być przeniesiony do DateType
     */
    String namespace

    /**
     * Opis znaczenia danych.
     */
    String description

    /**
     * Flaga określająca czy dane są wymagane.
     */
    boolean isRequired = false

    /**
     * Typ danych.
     */
    DataType dataType

    /**
     *  Dotyczy pola DATE_TIME
     */
    String format

    /**
     * Dotyczy pola tekstowego - wyrażenie regularne.
     */
    String pattern

    /**
     * Dotyczy pola tekstowego - min/max długość
     */
    Integer minLength
    Integer maxLength

    /**
     * Dotyczy pola liczbowego
     */
    String minimum
    String maximum

    /**
     * Dotyczy xsd
     */
    boolean isNillable;

    Map<Object, String> attributes = [:]

    String toString() {
        def attributes = getToStringAttributes()
        if (isObject()) {
            "$code OBJECT${getToStringAttributes()}"
        } else {
            (code ? code + ' ' : '') + dataType.toString() + (attributes ? attributes.toString() : '')
        }
    }

    List getToStringAttributes() {
        def result = []
        if (isRequired) result.add('required')
        if (isNillable) result.add('nillable')
        if (description) result.add("'$description'")
        result + dataType.toStringAttributes
    }

    boolean isEnum() {
        dataType.typeCode == DataTypeCode.ENUM
    }

    boolean isObject() {
        dataType.typeCode == DataTypeCode.OBJECT
    }

    boolean isArray() {
        dataType.typeCode == DataTypeCode.ARRAY
    }

    boolean isMap() {
        dataType.typeCode == DataTypeCode.MAP
    }

    boolean isType(DataTypeCode...types) {
        types.contains(dataType.typeCode)
    }

    EnumType getEnumType() {
        assert dataType.typeCode == DataTypeCode.ENUM
        (EnumType) dataType
    }

    ObjectType getObjectType() {
        assert dataType.typeCode == DataTypeCode.OBJECT
        (ObjectType) dataType
    }

    ArrayType getArrayType() {
        assert dataType.typeCode == DataTypeCode.ARRAY
        (ArrayType) dataType
    }

    MapType getMapType() {
        assert dataType.typeCode == DataTypeCode.MAP
        (MapType) dataType
    }

    String getFormat() {
        if (dataType instanceof ArrayType) {
            dataType.itemsSchema.format
        } else {
            this.format
        }
    }

    String getDescription() {
        this.description ?: isObject() ? getObjectType().description : null
    }

    void setAttribute(Object key, Supplier<String> value) {
        if (!attributes.containsKey(key)) {
            attributes.put(key, value.get())
        }
    }

    String getAttribute(Object key) {
        assert attributes.containsKey(key)
        attributes.get(key)
    }

    String getQname() {
        "{$namespace}$code"
    }
}
