/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java

interface JavaDefs {

    String T_LIST            = 'java.util.List'
    String T_MAP             = 'java.util.Map'
    String FUN               = 'java.util.function.Function'

    String ACCESS_PUBLIC     = 'public'
    String ACCESS_PRIVATE    = 'private'
    String ACCESS_PROTECTED  = 'protected'

    ClassCd I_SERIALIZABLE   = new ClassCd('java.io.Serializable')
    ClassCd T_OBJECT         = new ClassCd('java.lang.Object')
    ClassCd T_STRING         = new ClassCd('java.lang.String')
    ClassCd T_BOOLEAN        = new ClassCd('java.lang.Boolean')
    ClassCd T_LONG           = new ClassCd('java.lang.Long')
    ClassCd T_INTEGER        = new ClassCd('java.lang.Integer')
    ClassCd T_FLOAT          = new ClassCd('java.lang.Float')
    ClassCd T_DOUBLE         = new ClassCd('java.lang.Double')
    ClassCd T_DATE           = new ClassCd('java.util.Date')
    ClassCd T_BIG_DECIMAL    = new ClassCd('java.math.BigDecimal')
    ClassCd T_BYTE_ARRAY     = new ClassCd(className: 'byte', isArray: true)

    ClassCd GENERIC_T        = new ClassCd(className: 'T', isGeneric: true)
    ClassCd GENERIC_R        = new ClassCd(className: 'R', isGeneric: true)
    ClassCd FUN_T_R          = new ClassCd(FUN, [GENERIC_T, GENERIC_R])
    ClassCd LIST_R           = new ClassCd(T_LIST, [GENERIC_R])
    ClassCd LIST_T           = new ClassCd(T_LIST, [GENERIC_T])
    ClassCd LIST_ANONYMOUS   = new ClassCd(T_LIST)

    ClassCd COLLECTIONS      = new ClassCd('java.util.Collections')

    AnnotationCm ANNOT_LB_DATA = new AnnotationCm('lombok.Data')
    AnnotationCm ANNOT_LB_NO_ARGS_CONTR = new AnnotationCm('lombok.NoArgsConstructor')
    AnnotationCm ANNOT_LB_REQUIRED_ARGS_CONTR = new AnnotationCm('lombok.RequiredArgsConstructor')
    AnnotationCm ANNOT_LB_ACCESSORS = new AnnotationCm('lombok.experimental.Accessors', [chain: ValueCm.value('true')])
    AnnotationCm ANNOT_LB_EQ_AND_HC = new AnnotationCm('lombok.EqualsAndHashCode', [callSuper: ValueCm.value('true')])
    AnnotationCm ANNOT_NON_NULL = new AnnotationCm('javax.annotation.Nonnull')
    AnnotationCm ANNOT_NULLABLE = new AnnotationCm('javax.annotation.Nullable')
    AnnotationCm ANNOT_OVERRIDE = new AnnotationCm('java.lang.Override')
}
