/*
 * Copyright (c) 2018,2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java

import groovy.transform.EqualsAndHashCode
import groovy.transform.ToString

import static pl.metaprogramming.codemodel.model.java.JavaDefs.ACCESS_PRIVATE

@ToString(includePackage = false, includes = ['name', 'type'])
@EqualsAndHashCode(includes = ['name'])
class FieldCm {
    def metaModel
    String name
    String description
    ClassCd type
    List<AnnotationCm> annotations = []
    ValueCm value
    String modifiers = ACCESS_PRIVATE

    FieldCm() {}

    FieldCm(FieldCm fieldCm) {
        this.name = fieldCm.name
        this.type = fieldCm.type
    }

    void collectDependencies(Collection<ClassCd> dependencies) {
        type.collectDependencies(dependencies)
        annotations.each { it.collectDependencies(dependencies) }
    }

    boolean isStatic() {
        modifiers.contains('static')
    }

    void setFinal() {
        if (!modifiers.contains('final')) {
            modifiers = modifiers + ' final'
        }
    }

    String getExpression() {
        return value.toString()
    }
}
