/*
 * Copyright (c) 2018,2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java

class ClassCm extends ClassCd {
    boolean isInterface = false

    ClassCd extend
    String description

    List<String> imports = []
    List<AnnotationCm> annotations = []
    List<FieldCm> fields = []
    List<MethodCm> methods = []
    List<ClassCd> interfaces = []
    List<EnumItemCm> enumItems = []

    void addField(FieldCm fieldCm) {
        assert fields.find {
            it.name == fieldCm.name || (it.metaModel != null && it.metaModel == fieldCm.metaModel)
        } == null, "field $fieldCm.name already exists"
        fields.add(fieldCm)
    }
}
